/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakSet<E>
extends AbstractSet<E> {
    private final ReferenceQueue<E> queue = new ReferenceQueue();
    private final HashSet<Reference<E>> delegate = new HashSet();

    @Override
    @NotNull
    public synchronized Iterator<E> iterator() {
        return new Iterator<E>(){
            final Iterator<Reference<E>> delegate;
            E next;
            {
                this.delegate = WeakSet.this.delegate.iterator();
                this.next = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                WeakSet weakSet = WeakSet.this;
                synchronized (weakSet) {
                    if (this.delegate.hasNext()) {
                        this.next = WeakSet.unwrap(this.delegate.next());
                        return this.next != null || this.hasNext();
                    }
                }
                return false;
            }

            @Override
            public E next() {
                if (this.next == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object e = this.next;
                this.next = null;
                return e;
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        };
    }

    @Override
    public synchronized int size() {
        this.processQueue();
        return this.delegate.size();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.delegate.contains(WeakElement.create(o));
    }

    @Override
    public synchronized boolean add(E e) {
        this.processQueue();
        return this.delegate.add(WeakElement.create(e, this.queue));
    }

    @Override
    public synchronized boolean remove(Object o) {
        boolean ret = this.delegate.remove(WeakElement.create(o));
        this.processQueue();
        return ret;
    }

    @Override
    public synchronized void clear() {
        this.processQueue();
        this.delegate.clear();
    }

    @Nullable
    private static <T> T unwrap(@Nullable Reference<T> ref) {
        return ref == null ? null : (T)ref.get();
    }

    private void processQueue() {
        Reference<E> wv;
        while ((wv = this.queue.poll()) != null) {
            this.delegate.remove(wv);
        }
    }

    private static class WeakElement<E>
    extends WeakReference<E> {
        private final int hash;

        private WeakElement(E value) {
            super(value);
            this.hash = value.hashCode();
        }

        private WeakElement(E value, ReferenceQueue<E> queue) {
            super(value, queue);
            this.hash = value.hashCode();
        }

        private static <V> WeakElement<V> create(V value) {
            return value == null ? null : new WeakElement<V>(value);
        }

        private static <V> WeakElement<V> create(V value, ReferenceQueue<V> queue) {
            return value == null ? null : new WeakElement<V>(value, queue);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WeakElement)) {
                return false;
            }
            WeakElement v = (WeakElement)obj;
            return Objects.equals(this.get(), v.get());
        }

        public String toString() {
            return Objects.toString(this.get());
        }
    }
}

